package view;

import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.text.Font;

import model.GuessMyWordModel;

public class GuessView extends GridPane {

    private final GuessMyWordModel model;

    private TextField guessInput;
    private Button guessButton, resetButton;
    private Label guessSoFar;
    private final Alert alert = new Alert(Alert.AlertType.INFORMATION);

    public GuessView(GuessMyWordModel model) {
        this.model = model;
        GuessController controller = new GuessController(model, this);
        initView();
        addEventHandlers(controller);

        updateFromModel();
    }

    void updateFromModel() {
        guessSoFar.setText(model.getGuessSoFar());
        guessInput.requestFocus();
        guessInput.selectAll();
    }

    void updateOnReset() {
        guessSoFar.setText(model.getGuessSoFar());
        guessInput.setText("");
        guessInput.requestFocus();
    }

    String getGuessInput() {
        return guessInput.getText();
    }

    void showAlert(String message) {
        alert.setHeaderText("");
        alert.setTitle("Alert!");
        alert.setContentText(message);
        alert.show();
    }

    private void addEventHandlers(GuessController controller) {
        EventHandler guessHandler = new EventHandler<ActionEvent>() {
            @Override
            public void handle(ActionEvent event) {
                controller.handleGuessEvent();
            }
        };
        guessButton.setOnAction(guessHandler);
        guessInput.setOnAction(guessHandler);

        resetButton.setOnAction(new EventHandler<ActionEvent>() {
            @Override
            public void handle(ActionEvent event) {
                controller.handleResetEvent();
            }
        });
    }

    private void initView() {
        this.setPadding(new Insets(20, 20, 20, 20));
        this.setVgap(10);
        this.setHgap(10);

        guessInput = new TextField();
        guessButton = new Button("Guess");
        resetButton = new Button("Reset");
        guessSoFar = new Label("- - -");
        guessSoFar.setFont(Font.font("Verdana", 18));

        this.add(new Label("Enter a letter"), 0, 0);
        this.add(guessInput, 0, 1);
        this.add(guessButton, 1, 1);
        this.add(guessSoFar, 0, 2);
        this.add(resetButton, 0, 3);
    }
}
